function [Hhat,column,Full_Supports] = DS_OMP(Y,Phi,M,N,K,L1,L2,L2c)

Hhat=zeros(N,M,K);
T=size(Phi,1);

%% estimate the rows of supports H
e=0;
for k=1:K
  YK=Y(:,:,k); 
  e=e+sum(abs(YK).^2,1);
end
[~,index]=sort(e,'descend');
column=index(1:L1);
Full_Supports=zeros(L1,L2,K);

for c=1:L1
    %% estimate the common columns of supports H
    Yc=Y(:,column(c),:);
    Yc=reshape(Yc,T,K);
    Rc=Yc;
    rowc=[];
    Hchat=zeros(N,K);
    if L2c>0
        FullRow=zeros(L2,K);
        for k=1:K
            k;
            yc=Yc(:,k);
            rc=Rc(:,k);
            row=[];
            for r=1:L2
                e=abs(Phi'*rc).^2;
                [~,index]=max(e);
                row=[row index(1)];
                Phi_s=Phi(:,row);
                hchat=zeros(N,1);
                hchat(row,:)=inv(Phi_s'*Phi_s)*Phi_s'*yc;
                rc=yc-Phi*hchat;
            end
            FullRow(:,k)=row;
        end
        
        count=zeros(1,N);
        Fullcount=FullRow(:);
        for i=1:length(Fullcount)        
            count(Fullcount(i))= count(Fullcount(i))+1;
        end
        [~,index]= sort(count,'descend');
        rowc=index(1:L2c);

        Phi_s=Phi(:,rowc);
        Hchat=zeros(N,K);
        Hchat(rowc,:)=inv(Phi_s'*Phi_s)*Phi_s'*Yc;
        Rc=Yc-Phi*Hchat;
        Hhat(:,column(c),:)=Hchat;
    end
    
    %% estimate the user-specific columns of supports H
    for k=1:K
        k;
        yc=Yc(:,k);
        rc=Rc(:,k);
        row=rowc;
        for r=1:L2-L2c
            e=abs(Phi'*rc).^2;
            [~,index]=max(e);
            row=[row index(1)];
            Phi_s=Phi(:,row);
            hchat=zeros(N,1);
            hchat(row,:)=inv(Phi_s'*Phi_s)*Phi_s'*yc;
            rc=yc-Phi*hchat;
        end
        if L2-L2c>0
            Hhat(:,column(c),k)=hchat;
        end
        Full_Supports(c,:,k)=row;
    end  
end  
    
end

